#version 430

layout (location=0) in vec3 vertexPosition;
layout (location=1) in vec2 vertexUV;

out vec3 posV;
out vec2 uvV;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform float g_time;

uniform float surfGridRes2D;
// 3D grid size which is the same for width, height & depth
uniform float surfGridDim3D;


vec3 getPos3D(vec2 tp) {
    tp = round(tp);
    float kb = surfGridRes2D/surfGridDim3D; // 10 for example when dim3d is 100 and res2d is 1000
    vec3 pos3D = vec3(0.0);
    vec2 osa = tp/surfGridDim3D;
    vec2 cellXY = fract(osa)*surfGridDim3D;
    vec2 cellZ = floor(osa);
    float indZ = cellZ.x+cellZ.y*kb;
    pos3D = vec3(cellXY, indZ);
    return pos3D;
}

vec2 getPos2D(vec3 pos3D) {
    vec2 res;
    pos3D = floor(pos3D);
    float kb = surfGridRes2D/surfGridDim3D; // 10 for example when dim3d is 100 and res2d is 1000
    res.xy = fract(pos3D.xy/(surfGridDim3D))*(surfGridDim3D);
    float osa = floor(pos3D.z)/kb;
    res.x += fract(osa)*(surfGridRes2D);
    res.y += floor(osa)*(surfGridDim3D);
    return res;
}


void main() {
  vec3 pos3D = getPos3D(vertexUV);

  posV = pos3D;
  uvV = vertexUV;
}
